<?php
/**
 * Action functions for WPLMS 4
 *
 * @author      VibeThemes
 * @category    Admin
 * @package     WPLMS Plugin
 * @version     4.0
 */

 if ( ! defined( 'ABSPATH' ) ) exit;

class WPLMS_4_Actions{

    public static $instance;
    public static function init(){
    if ( is_null( self::$instance ) )
        self::$instance = new WPLMS_4_Actions();

        return self::$instance;
    }

    private function __construct(){

    	add_action('wplms_evaluate_quiz',array($this,'clear_cached_quiz'),10,4);
        add_action('the_content',array($this,'course_content'),1);
        add_action('init',array($this,'add_elementor_support'));

        add_action('wp_head',array($this,'add_taxonomies_json'),99);
        add_action('wp_enqueue_scripts',array($this,'enqueue_general'));

        add_action( 'add_meta_boxes', array($this,'course_layout_card'));
        add_action( 'save_post_member-profile', array($this,'save_course_layout_card' ),10,1);

    
    }

    function add_taxonomies_json(){


        if(function_exists('vibe_get_option') && !empty(vibe_get_option('redirect_course_cat_directory'))){
            $taxonomies = get_taxonomies( [ 'object_type' => [ 'course' ] ] );
            $course_taxonomies = [];
            foreach ($taxonomies as $key => $tax) {
                $course_taxonomies[] = $tax;
            }
            $course_taxonomies = apply_filters('wplms_course_taxonomies',$course_taxonomies);
            $object = get_queried_object();
            if(!empty($object) && !empty($object->taxonomy) && in_array($object->taxonomy, $course_taxonomies)){
                $json_data = array(
                    'property' => 'taxonomy',
                    'id'       => $object->taxonomy,
                    'values'   => array((string)$object->term_id),

                );
                ?>
                <script>
                    if(typeof course_directory_filters==='undefined'){
                        var course_directory_filters = [];
                    }
                    course_directory_filters.push(<?php echo json_encode($json_data);?>);
                </script>
                <?php
                
            }

        }
    }

    function add_elementor_support(){
        $post_types = apply_filters('wplms_elementor_post_type_supports',array('unit'));
        foreach ($post_types as $key => $cpt_slug) {
            add_post_type_support( $cpt_slug, 'elementor' );
        }
    }

    function clear_cached_quiz($quiz_id,$marks,$user_id,$max){
    	delete_user_meta($user_id,'quiz_cached_results');
    }

    function course_content($content){
        global $post;
        
        if($post->post_type == 'course' && !bp_is_directory()){
            if(function_exists('vibe_get_customizer')){
                $layout = vibe_get_customizer('course_layout');
            }
            
            if((empty($layout) || $layout == 'blank') && function_exists('elementor_load_plugin_textdomain')){
                if(!\Elementor\Plugin::$instance->db->is_built_with_elementor($post->ID)){
                    
                    $init = WPLMS_4_Init::init();
                    $init->course_id = get_the_ID();
                    $layout = new WP_Query(apply_filters('wplms_plugin_single_course_layout',array('post_type'=>'course-layout','posts_per_page'=>1)));
                    if($layout->have_posts()){
                        while($layout->have_posts()){
                            $layout->the_post();
                            global $post;
                            setup_postdata($post);
                            $content=$post->post_content;
                            $elementorFrontend = new \Elementor\Frontend();
                            $elementorFrontend->enqueue_scripts();
                            $elementorFrontend->enqueue_styles();
                        }
                    }
                }
            }
        }
        return $content;
    }


    function enqueue_general(){
        if(is_wplms_4_0('course') && is_singular('course')){
            wp_enqueue_style('wplms_plugin_elementor',plugins_url('../assets/css/general.css',__FILE__),array(),WPLMS_PLUGIN_VERSION);
        }
    }


    function course_layout_card() {
        add_meta_box( 'course_category_selector', __( 'Apply on Course Category', 'wplms' ), array($this,'course_category_selector'), 'course-layout','side' );
        add_meta_box( 'course_category_selector', __( 'Apply on  Course Category', 'wplms' ), array($this,'course_category_selector'), 'course-card' ,'side');
        add_meta_box( 'course_layout_selector', __( 'Apply Course Layout', 'wplms' ), array($this,'course_layout_selector'), 'course' ,'side');
    }
    function course_category_selector(){
        $cats = get_terms('course-cat',array('hide_empty'=>false));
        global $post;
        $selected_cat = get_post_meta($post->ID,'course-cat',true);
        ?>
        <select name="course-cat">
            <option value=""><?php _ex('Select Course Category','wplms'); ?></option>
            <?php
                if(!empty($cats)){
                    foreach ( $cats as $cat ) {
                        echo '<option value="'.$cat->term_id.'" '.($selected_cat == $cat?'selected':'').'>'.$cat->name.'</option>';  
                    }
                }
            ?>
        </select>
        <?php
        
    }


    function course_layout_selector(){

        $course_layout = get_post_meta($post->ID,'course_layout',true);
        ?>
        <label for="course-layout" class="screen-reader-text"><?php
            esc_html_e( 'Select Course Layout', 'wplms' );
        ?></label>
        <select name="course_layout">
            <option value=""><?php _ex('Select Course Layout','vibebp'); ?></option>
            <?php
            global $post;
            $ppost = $post;
            $query = new WP_Query(array(
                'post_type'=>'course-layout',
                'posts_per_page'=>-1
            ));
            if($query->have_posts()){
                while($query->have_posts()){
                    $query->the_post();
                    echo '<option value="'.get_the_ID().'" '.($profile_layout == get_the_ID()?'selected':'').'>'.get_the_title().'</option>';
                }
            }
            $post = $ppost;
            ?>
        </select>
        <?php
        
        wp_nonce_field( 'course-layout-change-' . $post->ID, 'course-layout-nonce' );

    }

    function process_member_profile_update(){

        if ( ! isset( $_POST['course-layout-nonce'] ) || ! isset( $_POST['course_layout'] ) ) {
            return;
        }
        if(!current_user_can('manage_options'))
            return;

        // Member type string must either reference a valid member type, or be empty.
        $course_layout = stripslashes( $_POST['course_layout']);
        update_post_meta($post->ID,'course_layout',$course_layout);
    }
}

WPLMS_4_Actions::init();

