<?php
/**
 * Action functions for WPLMS 4
 *
 * @author      VibeThemes
 * @category    Admin
 * @package     WPLMS Plugin
 * @version     4.0
 */

 if ( ! defined( 'ABSPATH' ) ) exit;

class WPLMS_4_Filters{

    public static $instance;
    public static function init(){
    if ( is_null( self::$instance ) )
        self::$instance = new WPLMS_4_Filters();

        return self::$instance;
    }

    private function __construct(){
    	add_filter('vibebp_component_icon',array($this,'course_component_icon'),10,2);
        add_filter('wplms_course_creation_tabs',array($this,'elementor_installed'));

        add_filter('vibebp_elementor_layout_template_post_types',array($this,'add_post_types'));

        //add_filter('bp_course_single_item_view',array($this,'course_card'));
            
            
        add_action('wplms_vibe_carousel',array($this,'course_carousel'));
        add_action('wplms_vibe_grid',array($this,'course_grid'));

        add_filter('elementor_course_block_id',array($this,'course_block_ID'));
    
    
        add_filter('vibebp_member_dashboard',array($this,'student_instructor_sidebar'),10,2);

        add_filter('vibebp_force_apply_translations',array($this,'apply_translations'),10,2);

        add_filter('wplms_course_info_display_options',array($this,'enable_level_location'));

        add_filter('wplms_meta_box_meta_value',array($this,'check_quiz_dynamicity'),10,3);

        
        add_filter('vibebp_api_get_activity',array($this,'course_filter'),10,3);

        add_filter('wplms_check_course_page_widget_post',array($this,'check12'),10,3);
    }


    function check12($post){
        
        if($post->post_type=='course-layout'){
            $id = apply_filters('elementor_course_block_id','');
            if(!empty($id)){
                $post = get_post($id);
            }
        }

        return $post;
    }


    function course_filter($activity_args,$args,$user_id = null){
        
        if(empty($user_id))
            return $activity_arg;

        if($args['filter'] === 'course'){
            $activity_args['filter'] = array('object'=>'course','user_id'=>$user_id); 
            if($args['primary_id']){
                $activity_args['filter']['primary_id']=$args['primary_id'];
            }
            if($args['item_id']){
                $activity_args['filter']['primary_id']=$args['item_id'];
            }
            if($args['secondary_item_id']){
                $activity_args['filter']['secondary_id']=$args['secondary_item_id'];
            }
        }

        if($args['filter'] === 'course_instructor'){

            $course_ids = bp_course_get_instructor_courses($user_id);
            if(empty($course_ids)){
                $activity_args['filter'] = array('primary_id'=>999999,'object'=>'course');    
            }else{
                $activity_args['filter'] = array('primary_id'=>$course_ids,'object'=>'course'); 
            } 
        }

        return $activity_args;
    }

    function check_quiz_dynamicity($value,$post_id,$field_id){

        if(empty($value) && $field_id=='vibe_quiz_dynamic'){
            $old_dynamic = get_post_meta($post_id,'vibe_quiz_dynamic',true);
            if(!empty($old_dynamic) && $old_dynamic =='S'){
                $value = 'dynamic';
            }else{
                $value = 'static';
            }
        }
        return $value;
    }

    function apply_translations($name,$item){
        if($item['parent'] == 'course'){
            $name=translate($name,'wplms');     
        }
        return $name;
    }

    

    function add_post_types($post_types) {

        $post_types[]='course-layout';
        $post_types[]='course-card';

        return $post_types;

    }

    function course_card($view){

        if(is_wplms_4_0()){
            $layout = new WP_Query(apply_filters('wplms_plugin_single_course_layout',array('post_type'=>'course-card','posts_per_page'=>1)));
            if($layout->have_posts()){
                while($layout->have_posts()){
                    $layout->the_post();
                    global $post;
                    $content=$post->post_content;
                    $elementorFrontend = new \Elementor\Frontend();
                    $elementorFrontend->enqueue_scripts();
                    $elementorFrontend->enqueue_styles();
                    return $content;
                }
            }
        }

        return $view;
    }

    function course_carousel($elementor){
        $elementor->add_control(
            'course_type',
            [
                'label' =>__('Profile Courses', 'wplms'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'mycourses' => [
                        'title' => __( 'my_courses', 'wplms' ),
                        'icon' => 'vicon vicon-bookmark-alt',
                    ],
                    'instructing_courses' => [
                        'title' => __( 'Instructing Courses', 'wplms' ),
                        'icon' => 'vicon vicon-marker-alt',
                    ],
                ],
            ]
        );
    }

    
    function course_grid($elementor){
        $elementor->add_control(
            'course_type',
            [
                'label' =>__('Profile Courses', 'wplms'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'mycourses' => [
                        'title' => __( 'my_courses', 'wplms' ),
                        'icon' => 'vicon vicon-bookmark-alt',
                    ],
                    'instructing_courses' => [
                        'title' => __( 'Instructing Courses', 'wplms' ),
                        'icon' => 'vicon vicon-marker-alt',
                    ],
                ],
            ]
        );
    }

    function course_block_ID($id){
        
        if(!empty($this->featured_id)){
            return $this->featured_id;
        }

        $init = WPLMS_4_Init::init();
        if(empty($id) && !empty($init->course_id)){
            $id = $init->course_id;
        }
        
        if(empty($id)){
            global $post;
            if($post->post_type == 'course-layout' || $post->post_type =='course-card'){
                
                if(empty($this->course_id)){
                    $course_query = new WP_Query(array('post_type'=>'course','posts_per_page'=>1,'orderby'=>'random'));
                    if($course_query->have_posts()){
                        while($course_query->have_posts()){
                            $course_query->the_post();
                            $this->course_id = get_the_Id();
                        }
                    }
                    wp_reset_postdata();
                }
                return $this->course_id;
            }
            if($post->post_type == 'course'){
                    $id = $post->ID;                    
            }
        }

        return $id;
    }

    function course_component_icon($icon,$id){
    	if($id == 'course'){
    		$icon = '<svg width="24" height="24" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" xmlns:serif="http://www.serif.com/" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2;">
    <path d="M24,21L21,21L22,18L23,18L24,21ZM23,17L22,17L22,9.74L11.077,15.308L0,8.308L12,3L23,9.231L23,17Z"/>
    <path d="M11.024,16.457L20,11.882L20,18C18.993,20.041 14.393,21 11.5,21C8.325,21 4.111,20.006 3,18L3,11.386L11.024,16.457Z" style="fill-opacity:0.6;"/>
</svg>';
    	}
    	return $icon;
    }


    function elementor_installed($tabs){
        $tabs['course_curriculum']['fields'][0]['curriculum_elements'][1]['types'][] =array(
                'id'=>'elementor',
                'icon'=>'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="72" height="72"><path d="M 5 5 L 5 27 L 27 27 L 27 5 L 5 5 z M 7 7 L 25 7 L 25 25 L 7 25 L 7 7 z M 11 11 L 11 21 L 13 21 L 13 11 L 11 11 z M 15 11 L 15 13 L 21 13 L 21 11 L 15 11 z M 15 15 L 15 17 L 21 17 L 21 15 L 15 15 z M 15 19 L 15 21 L 21 21 L 21 19 L 15 19 z"></path></svg>',
                'label'=>__('Elementor','wplms'),
                'fields'=>array(
                    array(
                        'label'=> __('Unit title','wplms' ),
                        'type'=> 'title',
                        'id' => 'post_title',
                        'from'=>'post',
                        'value_type'=>'single',
                        'style'=>'full',
                        'default'=> __('Unit Name','wplms' ),
                        'desc'=> __('This is the title of the unit which is displayed on top of every unit','wplms' )
                        ),
                    array(
                        'label'=> __('Unit Tag','wplms' ),
                        'type'=> 'taxonomy',
                        'taxonomy'=> 'module-tag',
                        'from'=>'taxonomy',
                        'value_type'=>'single',
                        'style'=>'assign_cat',
                        'id' => 'module-tag',
                        'default'=> __('Select a tag','wplms' ),
                    ),
                    array(
                        'label'=> __('What is the unit about','wplms' ),
                        'type'=> 'elementor',
                        'style'=>'',
                        'value_type'=>'single',
                        'id' => 'post_content',
                        'from'=>'post',
                        'extras' => '',
                        'default'=> __('Enter description about the unit.','wplms' ),
                        ),
                    array(
                        'label'=> __('Unit duration','wplms' ),
                        'type'=> 'duration',
                        'style'=>'course_duration_stick_left',
                        'id' => 'vibe_duration',
                        'from'=> 'meta',
                        'default'=> array('value'=>9999,'parameter'=>86400),
                        'from'=>'meta',
                    ),
                    array( 
                        'label' => __('Free Unit','wplms'),
                        'desc'  => __('Set Free unit, viewable to all','wplms'), 
                        'id'    => 'vibe_free',
                        'type'  => 'switch',
                        'default'   => 'H',
                        'from'=>'meta',
                    ),
                    array(
                        'label' => __('Unit Forum','wplms'),
                        'desc'  => __('Connect Forum with Unit.','wplms'),
                        'id'    => 'vibe_forum',
                        'type'  => 'selectcpt',
                        'post_type' => 'forum',
                        'std'=>0,
                        'from'=>'meta',
                    ),
                    array(
                        'label' => __('Connect Assignments','wplms'),
                        'desc'  => __('Select an Assignment which you can connect with this Unit','wplms'),
                        'id'    => 'vibe_assignment',
                        'type'  => 'selectmulticpt', 
                        'post_type' => 'assignment',
                        'from'=>'meta',
                    ),
                    array(
                        'label' => __('Attachments','wplms'),
                        'desc'  => __('Display these attachments below units to be downloaded by students','wplms'),
                        'id'    => 'vibe_unit_attachments', 
                        'type'  => 'multiattachments', 
                        'from'=>'meta',
                    )
                )
            );
        return $tabs;
    }

    function student_instructor_sidebar($sidebar,$user_id){

        $user = get_userdata( $user_id );
        if(!empty($user)){
            if ( in_array( 'student', $user->roles, true ) ) {
                return 'student_sidebar';
            }    
            if ( in_array( 'instructor', $user->roles, true ) ) {
                return 'instructor_sidebar';
            }    
        }

        return $sidebar;
    }

    function enable_level_location($info){

        if(function_exists('vibe_get_option') && vibe_get_option('level')){
            $info['level']=__('Course Levels','wplms');
        }
        if(function_exists('vibe_get_option') && vibe_get_option('location')){
            $info['location']=__('Course Location','wplms');
        }
        return $info;
    }
}

WPLMS_4_Filters::init();

