<?php
add_action( 'widgets_init', 'wplms_student_stats' );

function wplms_student_stats() {
    register_widget('wplms_student_stats');
}

class wplms_student_stats extends WP_Widget {
  
   
    /** constructor -- name this the same as the class above */
    function __construct() {
        $widget_ops = array( 'classname' => 'wplms_student_stats', 'description' => __('Student Statistics widget', 'wplms') );
        $control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'wplms_student_stats' );
        parent::__construct( 'wplms_student_stats', __(' DASHBOARD : Student Stats', 'wplms'), $widget_ops, $control_ops );

        add_action('wp_enqueue_scripts',array($this,'enqueue_script'));
        add_filter('vibebp_member_dashboard_widgets',array($this,'add_custom_script'));
    
    }
    function add_custom_script($x){
      $x[] = 'wplms_student_stats';
      return $x;
    }    
    function enqueue_script(){
        
        if( bp_current_component() == 'dashboard' || apply_filters('vibebp_enqueue_profile_script',false)){

          wp_enqueue_script('wplms_dashboard_student_stats',WPLMS_PLUGIN_URL.'/assets/js/student_stats.js',array('wp-element'),WPLMS_DASHBOARD_VERSION,true);
          wp_enqueue_style('wplms_dashboard_css',WPLMS_PLUGIN_URL.'/assets/css/dashboard.css',array(),WPLMS_DASHBOARD_VERSION);
          wp_localize_script('wplms_dashboard_student_stats','student_stats',apply_filters('wplms_dashboard_student_stats',array(
            'settings'      => array(),
            'api'           => rest_url(BP_COURSE_API_NAMESPACE . '/dashboard/widget'),
            'user_id'       => get_current_user_id(),
            'translations'  => array(
                                  'course'      =>__('Course','wplms'),
                                  'quiz'        =>__('Quiz','wplms'),
                                  'assignments' =>__('Assignment','wplms'),
                                  'not_found'=>__('Not Found','wplms'),
                                )
          )));
        }
      }

 
    /** @see WP_Widget::widget -- do not rename this */
    function widget( $args, $instance ) {
        extract( $args );

        //Our variables from the widget settings.
        $title              = $instance['title'];
        $course_graphs      = $instance['course'];
        $quiz_graphs        = $instance['quiz'];
        $assignment_graphs  = $instance['assignments'];
        $width              = $instance['width'];
        $course_chart       = $instance['course_chart'];
        $quiz_chart         = $instance['quiz_chart'];
        $assignment_chart   = $instance['assignment_chart'];

        if(!empty($before_title)) $instance['before_title'] = $before_title; else $instance['before_title'] = '';
        if(!empty($after_title)) $instance['after_title'] = $after_title; else $instance['after_title'] = '';
        // print_r($instance);

    echo '<div class="'.$width.'"><div class="dash-widget">'.$before_widget;
     echo '<div class="wplms_dashboard_student_stats"></div>';
    
 
        echo '</div>';
        echo $after_widget.'</div></div>';
    }
 
    /** @see WP_Widget::update -- do not rename this */
    function update($new_instance, $old_instance) {   
      $instance = $old_instance;
      $instance['title'] = strip_tags($new_instance['title']);
      $instance['width'] = $new_instance['width'];
      $instance['course'] = $new_instance['course'];
      $instance['quiz'] = $new_instance['quiz'];
      $instance['assignments'] = $new_instance['assignments'];
      $instance['course_chart'] =$new_instance['course_chart'];
      $instance['quiz_chart'] =$new_instance['quiz_chart'];
      $instance['assignment_chart'] =$new_instance['assignment_chart'];
      return $instance;
    }
 
    /** @see WP_Widget::form -- do not rename this */
    function form($instance) {  
        $defaults = array( 
                        'title'  => __('Student Statistics','wplms'),
                        'width' => 'col-md-6 col-sm-12',
                        'chart'=>'Line'
                    );
        $instance = wp_parse_args( (array) $instance, $defaults );
        $title  = esc_attr($instance['title']);
        $quiz  = esc_attr($instance['quiz']);
        $quiz_chart  = esc_attr($instance['quiz_chart']);
        $assignments  = esc_attr($instance['assignments']);
        $assignment_chart  = esc_attr($instance['assignment_chart']);
        $course  = esc_attr($instance['course']);
        $course_chart  = esc_attr($instance['course_chart']);
        $width = esc_attr($instance['width']);
        ?>
        <p>
          <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:','wplms'); ?></label> 
          <input class="regular_text" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        <p>
          <label for="<?php echo $this->get_field_id('course'); ?>"><?php _e('Show Course statistics','wplms'); ?></label> 
          <input class="checkbox" id="<?php echo $this->get_field_id( 'course' ); ?>" name="<?php echo $this->get_field_name( 'course' ); ?>" type="checkbox" value="1"  <?php checked($course,1,true) ?>/>
        </p>
        
        <p>
          <label for="<?php echo $this->get_field_id('quiz'); ?>"><?php _e('Show Quiz statistics','wplms'); ?></label> 
          <input class="checkbox" id="<?php echo $this->get_field_id( 'quiz' ); ?>" name="<?php echo $this->get_field_name( 'quiz' ); ?>" type="checkbox" value="1"  <?php checked($quiz,1,true) ?>/>
        </p>
        
        <p>
          <label for="<?php echo $this->get_field_id('assignments'); ?>"><?php _e('Show Assignments statistics','wplms'); ?></label> 
          <input class="checkbox" id="<?php echo $this->get_field_id( 'assignments' ); ?>" name="<?php echo $this->get_field_name( 'assignments' ); ?>" type="checkbox" value="1"  <?php checked($assignments,1,true) ?>/>
        </p>
        
        <p>
          <label for="<?php echo $this->get_field_id('width'); ?>"><?php _e('Select Width','wplms'); ?></label> 
          <select id="<?php echo $this->get_field_id('width'); ?>" name="<?php echo $this->get_field_name('width'); ?>">
            <option value="col-md-3 col-sm-6" <?php selected('col-md-3 col-sm-6',$width); ?>><?php _e('One Fourth','wplms'); ?></option>
            <option value="col-md-4 col-sm-6" <?php selected('col-md-4 col-sm-6',$width); ?>><?php _e('One Third','wplms'); ?></option>
            <option value="col-md-6 col-sm-12" <?php selected('col-md-6 col-sm-12',$width); ?>><?php _e('One Half','wplms'); ?></option>
            <option value="col-md-8 col-sm-12" <?php selected('col-md-8 col-sm-12',$width); ?>><?php _e('Two Third','wplms'); ?></option>
             <option value="col-md-8 col-sm-12" <?php selected('col-md-9 col-sm-12',$width); ?>><?php _e('Three Fourth','wplms'); ?></option>
            <option value="col-md-12" <?php selected('col-md-12',$width); ?>><?php _e('Full','wplms'); ?></option>
          </select>
        </p>
        <?php 
    }
} 

?>