<?php
/**
 * Init in VibeZoom
 *
 * @author 		VibeThemes
 * @category 	Admin
 * @package 	vibe_zoom/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Vibe_Zoom_Init{

	public static $instance;
    
    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Vibe_Zoom_Init();
        return self::$instance;
    }

	private function __construct(){

		add_filter('wplms_course_creation_tabs',array($this,'zoom_unit'));
        add_action('wp_enqueue_scripts',array($this,'enqueue_script'));
        add_action( 'init', array( $this,'register_post_types') );
        add_action( 'bp_setup_nav', array($this,'add_zoom_tab'), 100 );

        add_filter('vibebp_component_icon',array($this,'set_icon'),10,2);
        add_filter('wplms_get_element_icon',array($this,'set_icon'),10,2);
        add_Action('rest_api_init',function(){
            add_filter('the_content',array($this,'curriculum_zoom_meeting'),10,4);    
        });
        //Connect course created.
        add_filter('wplms_course_created_updated',array($this,'connect_zoom_id'),10,2);

    }

    function curriculum_zoom_meeting($post_content,$user_id=null,$item_id=null,$course_id=null){
        if(empty($user_id) || empty($item_id) || empty($course_id)){
            return $post_content;
        }

        $meeting_id = get_post_meta($item_id,'vibe_zoom_meeting',true);

        if(!empty($meeting_id)){
            $details = get_post_meta($meeting_id,'vibe_zoom_meeting_details',true);
            
           
            if(!empty($details) && isset($details['start_url']) && isset($details['join_url'])){

                $metting_UTC_time ='';
                if(!empty($details['start_time'])) {
                    $metting_UTC_time = strtotime($details['start_time']);
                    $vibe_zoom = Vibe_Zoom::init();
                    $tiemzones = $vibe_zoom->vibe_zoom_get_timezone_options();
                    preg_match('/GMT(.+)\)/',$tiemzones[$meta['time_zone']],$matches);
                    $timearray = explode(':',substr($matches[1], 1, strlen($matches[1])));
                    $sign = substr($matches[1], 0, 1);
                    $seconds = intval($timearray[0])*60+intval($timearray[1]);
                    
                    if($sign == '+'){
                        $metting_UTC_time -= $seconds;
                    }else{
                        $metting_UTC_time += $seconds;    
                    }
                    
                }
                $meeting_duration_in_minutes = get_post_meta($meeting_id,'duration',true);
                
                
                $post_content .= '<ul class="zoom_meeting_details">
                <li><strong>'._x('Join Password','vibe-zoom').'</strong><span>'.$details['password'].'</span></li><li><strong>'._x('Meeting Duration [minutes]','vibe-zoom').'</strong><span>'.$meeting_duration_in_minutes.'</span></li><li><strong>'._x('Meeting Start','vibe-zoom').'</strong><span>'.(function_exists('tofriendlytime')? tofriendlytime(($metting_UTC_time-time())):$metting_UTC_time).'</span></li>
                </ul>';

                if(intval($metting_UTC_time) <= time() && (intval($metting_UTC_time)+intval($meeting_duration_in_minutes)*60) > time()){
                    $post_content .= '[iframe]'.$details['join_url'].'[/iframe]';    
                }

                return $post_content;
            }
        }

        return $post_content;
    }

    function set_icon($icon,$component_name){

        if($component_name == 'zoom' || $component_name == 'vibezoom' || $component_name == 'zoom_meeting'){
            return '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M16 16c0 1.104-.896 2-2 2h-12c-1.104 0-2-.896-2-2v-8c0-1.104.896-2 2-2h12c1.104 0 2 .896 2 2v8zm8-10l-6 4.223v3.554l6 4.223v-12z"/></svg>';
        }
        return $icon;
    }
    
    function register_post_types(){
        register_post_type( 'vibe_zoom',
			array(
				'labels' => array(
					'name' => __('Zoom meetings','vibe-zoom'),
					'menu_name' => __('VibeZoom','vibe-zoom'),
					'singular_name' => __('Meetings','vibe-zoom'),
					'add_new_item' => __('Add New Meeting','vibe-zoom'),
					'all_items' => __('Zoom Meetings','vibe-zoom')
				),
				'public' => false,
				'show_in_rest' => true,
				'publicly_queryable' => false,
				'show_ui' => true,
				'capability_type' => 'page',
	            'has_archive' => true,
				'show_in_menu' => 'vibebp',
				'show_in_admin_bar' => false,
				'show_in_nav_menus' => false,
				'supports' => array( 'title','editor','custom-fields'),
				'hierarchical' => false,
			)
		);
    }

    function add_zoom_tab(){
        global $bp;
            
        if(function_exists('is_wplms_4_0') && is_wplms_4_0()){
            $slug = 'zoom_meeting';
            bp_core_new_nav_item( array( 
                'name' => __('Zoom Meetings','vibe-zoom'),
    	        'slug' => $slug, 
    	        'item_css_id' => 'zoom_meetings',
    	        'screen_function' => array($this,'show_screen'),
    	        'default_subnav_slug' => 'home', 
    	        'position' => 58,
            	'show_for_displayed_user'=>false,
    	        'user_has_access' => (bp_is_my_profile() || current_user_can('manage_options'))
    	    ) );
    		bp_core_new_subnav_item( array(
    			'name' 		  => __('My Meetings','vibe-zoom'),
    			'slug' 		  => 'my_meetings',
    			'parent_slug' => $slug,
            	'parent_url' => $bp->displayed_user->domain.$slug.'/',
    			'screen_function' => array($this,'show_screen'),
    			'user_has_access' => true
    		) );

    	    bp_core_new_subnav_item( array(
    			'name' 		  => __('Manage Meeting','vibe-zoom'),
    			'slug' 		  => 'manage_meetings',
    			'parent_slug' => $slug,
            	'parent_url' => $bp->displayed_user->domain.$slug.'/',
    			'screen_function' => array($this,'show_screen'),
    			'user_has_access' => (bp_is_my_profile() || current_user_can('manage_options'))
            ) );
            
            if (  apply_filters('show_vibezoom_vibecalendar',true)) {
                bp_core_new_subnav_item( array(
                    'name' 		  => __('Zoom Meetings','vibe-zoom'),
                    'slug' 		  => 'vibe_zoom_meeting',
                    'parent_slug' => 'calendar',
                    'parent_url' => $bp->displayed_user->domain.$slug.'/',
                    'screen_function' => array($this,'show_screen'),
                    'user_has_access' => (bp_is_my_profile() || current_user_can('manage_options'))
                ) );
            }
        }
	}

	function zoom_unit($tabs){
		$tabs['course_curriculum']['fields'][0]['curriculum_elements'][1]['types'][]= array(
			'id'=>'zoom',
            'icon'=>'<svg class="zoom_icon" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M16 16c0 1.104-.896 2-2 2h-12c-1.104 0-2-.896-2-2v-8c0-1.104.896-2 2-2h12c1.104 0 2 .896 2 2v8zm8-10l-6 4.223v3.554l6 4.223v-12z"/></svg>',
            'label'=>__('Zoom','vibe-zoom'),
            'fields'=>array(
                array(
                    'label'=> __('Unit title','vibe-zoom' ),
                    'type'=> 'title',
                    'id' => 'post_title',
                    'from'=>'post',
                    'value_type'=>'single',
                    'style'=>'full',
                    'default'=> __('Unit Name','vibe-zoom' ),
                    'desc'=> __('This is the title of the unit which is displayed on top of every unit','vibe-zoom' )
                    ),
                array(
                    'label'=> __('Unit Tag','vibe-zoom' ),
                    'type'=> 'taxonomy',
                    'taxonomy'=> 'module-tag',
                    'from'=>'taxonomy',
                    'value_type'=>'single',
                    'style'=>'assign_cat',
                    'id' => 'module-tag',
                    'default'=> __('Select a tag','vibe-zoom' ),
                ),
                array(
                    'label'=> __('Add Zoom Meeting','vibe-zoom' ),
                    'type'=> 'selectcpt',
                    'level'=>'zoom',
                    'post_type'=>'vibe_zoom',
                    'value_type'=>'single',
                    'upload_title'=>__('Upload a Video','vibe-zoom' ),
                    'desc'=>__('Select a Zoom Meeting. Create new meetings in Zoom Meetings Menu.','vibe-zoom' ),
                    'upload_button'=>__('Set as unit Video','vibe-zoom' ),
                    'style'=>'small_icon',
                    'from'=>'meta',
                    'is_child'=>true,
                    'id' => 'vibe_zoom_meeting',
                    'default'=> '',
                ),
                array(
                    'label'=> __('What is the unit about','vibe-zoom' ),
                    'type'=> 'editor',
                    'style'=>'',
                    'value_type'=>'single',
                    'id' => 'post_content',
                    'from'=>'post',
                    'extras' => '',
                    'default'=> __('Enter description about the unit.','vibe-zoom' ),
                ),
                array(
                    'label'=> __('Unit duration','vibe-zoom' ),
                    'type'=> 'duration',
                    'style'=>'course_duration_stick_left',
                    'id' => 'vibe_duration',
                    'from'=> 'meta',
                    'default'=> array('value'=>9999,'parameter'=>86400),
                    'from'=>'meta',
                ),
                array( 
                    'label' => __('Free Unit','vibe-zoom'),
                    'desc'  => __('Set Free unit, viewable to all','vibe-zoom'), 
                    'id'    => 'vibe_free',
                    'type'  => 'switch',
                    'default'   => 'H',
                    'from'=>'meta',
                ),
                array(
                    'label' => __('Unit Forum','vibe-zoom'),
                    'desc'  => __('Connect Forum with Unit.','vibe-zoom'),
                    'id'    => 'vibe_forum',
                    'type'  => 'selectcpt',
                    'post_type' => 'forum',
                    'std'=>0,
                    'from'=>'meta',
                ),
                array(
                    'label' => __('Connect Assignments','vibe-zoom'),
                    'desc'  => __('Select an Assignment which you can connect with this Unit','vibe-zoom'),
                    'id'    => 'vibe_assignment',
                    'type'  => 'selectmulticpt', 
                    'post_type' => 'assignment',
                    'from'=>'meta',
                ),
                array(
                    'label' => __('Attachments','vibe-zoom'),
                    'desc'  => __('Display these attachments below units to be downloaded by students','vibe-zoom'),
                    'id'    => 'vibe_unit_attachments', 
                    'type'  => 'multiattachments', 
                    'from'=>'meta',
                ),
            ),
		);
		return $tabs;
	}


	function enqueue_script(){
        $blog_id = '';
        if(function_exists('get_current_blog_id')){
            $blog_id = get_current_blog_id();
        }

            
		$zoom=apply_filters('wplms-zoom_script_args',array(
			'api'=>array(
				'url'=>get_rest_url($blog_id,VIBE_ZOOM_API_NAMESPACE),
				'create_caps'=>'edit_posts',
            ),
            'settings'=>array(
				'editor_slug' => apply_filters('vibezoom_editor_slug',array('manage_meetings')),
                'timestamp'=>time(),
                'new_vibezoom_cap'=>['edit_posts']
            ),
            'label'=>__('Vibe Zoom','vibe-zoom'),
            'sorters'=>array(
                'date'=>_x('Recent','vibe-zoom'),
				'name'=>_x('Alphabetical','vibe-zoom'),
			),
            'shared_tabs'=>array(
                'shared'=>_x('Shared ','vibe-zoom'),
				'group'=>_x('Group','vibe-zoom'),
                'course'=>_x('Course','vibe-zoom'),
            ),
            'shared_types'=>array(
                'shared'=>_x('Shared ','vibe-zoom'),
				'group'=>_x('Group','vibe-zoom'),
                'course'=>_x('Course','vibe-zoom'),
            ),
            'translations'=>array(
				'my_zooms'=>__('My Meetings', 'vibe-zoom'),
				'create_zoom'=>__('Create New', 'vibe-zoom'),
                'meeting_title'=>__('Meeting Title', 'vibe-zoom'),
                'meeting_content'=>__('Meeting Content', 'vibe-zoom'),
                'zoom_category'=>__('Meeting Category', 'vibe-zoom'),
                'no_zooms'=>__('No Meetings found.', 'vibe-zoom'),
                'search_text'=>__('Type to Search..', 'vibe-zoom'),
                'submit'=>__('Submit Meeting', 'vibe-zoom'),
                'preview'=>__('Preview Meeting', 'vibe-zoom'),
				'new_zoom_cateogry'=>__('New Meeting Category', 'vibe-zoom'),
				'load_more'=>__('Load more', 'vibe-zoom'),
				'no_steps_created'=>__('No Steps Created!', 'vibe-zoom'),
				'title'=>__('Title', 'vibe-zoom'),
                'description'=>__('Description', 'vibe-zoom'),
                'meeting_start_time'=>__('Meeting Start Time', 'vibe-zoom'),
                'meeting_end_time'=>__('Meeting End Time', 'vibe-zoom'),
                'meeting_duration_in_minutes'=>__('Meeting Duration In Minutes', 'vibe-zoom'),
                'password'=>__('Password', 'vibe-zoom'),
                'select_sharing_type'=>__('Select Sharing Type', 'vibe-zoom'),
                'select_shared_value'=>__('Select Shared Items', 'vibe-zoom'),
                'search_shared_values'=>__('Search sharing value', 'vibe-zoom'),
                'join_before_host'=>__('Join Before Host', 'vibe-zoom'),
                'host_video'=>__('Host Video', 'vibe-zoom'),
                'participant_video'=>__('Participants Video', 'vibe-zoom'),
                'mute_upon_entry'=>__('Mute Upon Entry', 'vibe-zoom'),
                'enforce_login'=>__('Enforce Login', 'vibe-zoom'),
                'auto_recording'=>__('Auto Recording', 'vibe-zoom'),
                'select_host'=>__('Select Host', 'vibe-zoom'),
                'select_host_user'=>__('Select Host User', 'vibe-zoom'),
                'time_zone'=>__('Time Zone', 'vibe-zoom'),
                'select_time_zone'=>__('Select Time Zone', 'vibe-zoom'),
                'shared_with'=>__('Shared With', 'vibe-zoom'),
                'search_results'=>__('Search Result', 'vibe-zoom'),
                'start_date'=>__('Start Date','vibe-zoom'),
                'start_url'=>__('Start Url','vibe-zoom'),
				'join_url'=>__('Join Url','vibe-zoom'),
                'timezone'=>__('TimeZone','vibe-zoom'),
                'minutes'=>__('Minutes','vibe-zoom'),
                'open_meeting'=> __('Open Meeting','vibe-zoom'),
                'start_meeting'=> __('Start Meeting','vibe-zoom'),
                'passcode'=>  __('Passcode:','vibe-zoom'),
                'click_to_copy'=>__('Click To Copy Code','vibe-zoom'),
                'meeting_over'=>__('Meeting Over','vibe-zoom'),
                'meeting_running'=>__('Meeting Running','vibe-zoom'),
                'days'=>__('Days','vibe-zoom'),
                'hours'=>__('Hours','vibe-zoom'),
                'minutes'=>__('Minutes','vibe-zoom'),
                'seconds'=>__('Seconds','vibe-zoom'),
                'open_meeting_in_new_tab'=>__('Open Meeting In New Tab','vibe-zoom'),
                'today'=>__('Today','vibe-zoom'),
                'month'=>__('Month','vibe-zoom'),
                'week'=>__('Week','vibe-zoom'),
                'day'=>__('Day','vibe-zoom'),
                'list'=>__('List','vibe-zoom'),
                'starts'=>__('Starts','vibe-zoom'),
                'ends'=>__('Ends','vibe-zoom'),
                'cancel'=>__('Cancel','vibe-zoom'),
                'view_details'=>__('View Details','vibe-zoom'),
            )
        ));
        if(function_exists('bp_is_user') && bp_is_user() || apply_filters('vibebp_enqueue_profile_script',false)){
            wp_enqueue_script('createzoom',plugins_url('../assets/js/create_zoom.js',__FILE__),array('wp-element','wp-data'),VIBE_ZOOM_VERSION);
            wp_enqueue_script('zoom_calendar',plugins_url('../assets/js/zoom_calendar.js',__FILE__),array('wp-element','wp-data'),VIBE_ZOOM_VERSION);
            wp_localize_script('createzoom','vibezoom',$zoom);
            wp_enqueue_style('vibe-zoom',plugins_url('../assets/css/create_zoom.css',__FILE__),array(),VIBE_ZOOM_VERSION);
        }

	}


    function connect_zoom_id($return,$body){
        if(!empty($return['course_id'])){
            foreach($body['course']['meta'] as $meta){
                if($meta['meta_key'] == 'vibe_course_curriculum' && is_Array($meta['meta_value'])){
                    global $wpdb;
                    $ids = [];
                    foreach($meta['meta_value'] as $val){
                        if(is_numeric($val)){
                            $ids[]=$val;
                        }
                    }
                    $zoom_meetings = $wpdb->get_results("SELECT post_id,meta_value FROM {$wpdb->postmeta} WHERE meta_key='vibe_zoom_meeting' AND post_id IN (".implode(',',$ids).")");
                   
                    if(!empty($zoom_meetings)){
                        foreach($zoom_meetings as $meeting_id){
                            update_post_meta($meeting_id->meta_value,'shared_type','course');
                            $values = get_post_meta($meeting_id,'shared_values',false);
                            if(empty($values) || !in_Array($return['course_id'],$values)){
                                add_post_meta($meeting_id->meta_value,'shared_values',$return['course_id']);
                            }
                        }
                    }
                }
            }
        }
        return $return; 
    }
}

Vibe_Zoom_Init::init();
