<?php
/**
 * PRofile
 *
 * @class       Vibe_Projects_Profile
 * @author      VibeThemes
 * @category    Admin
 * @package     vibecal
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Vibe_Cal_Init{


	public static $instance;
	public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Vibe_Cal_Init();
        return self::$instance;
    }

	private function __construct(){

		add_action('init',array($this,'register_types'));
		add_action( 'bp_setup_nav', array($this,'add_projects_tab'), 100 );
		add_action('wp_enqueue_scripts',array($this,'enqueue_script'));
		add_filter('vibebp_component_icon',array($this,'set_icon'),10,2);
		
		add_action( 'init', array($this,'register_custom_post_type'));
		add_action( 'init', array($this,'create_nonhierarchical_taxonomy'));

		add_filter('vibecal_script_args',array($this,'script_args'));
	}


	function register_types(){

	}

	function script_args($args){

		if(function_exists('vibebp_get_setting') && vibebp_get_setting('google_maps_key')){
			$args['settings']['fields']=array(
                        'label'=> __('Location','vibecal' ),
                        'type'=> 'location',
                        'style'=>'',
                        'value_type'=>'single',
                        'id' => 'location',
                        'from'=>'meta',
                        'extras' => '',
                    );
		}

		return $args;
	}

	function set_icon($icon,$component_name){
		if($component_name == 'calendar'){
			return '<svg width="24" height="24" viewBox="0 0 24 24" version="1.1" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2;">
			    <path fill="#fff" d="M20,20L16,20L16,16L20,16L20,20ZM14,10L10,10L10,14L14,14L14,10ZM20,10L16,10L16,14L20,14L20,10ZM8,16L4,16L4,20L8,20L8,16ZM14,16L10,16L10,20L14,20L14,16ZM8,10L4,10L4,14L8,14L8,10Z" style="fill-opacity:0.67;fill-rule:nonzero;"/>
			    <path fill="#fff" d="M24,2L24,24L0,24L0,2L3,2L3,3C3,4.103 3.897,5 5,5C6.103,5 7,4.103 7,3L7,2L17,2L17,3C17,4.103 17.897,5 19,5C20.103,5 21,4.103 21,3L21,2L24,2ZM22,8L2,8L2,22L22,22L22,8ZM20,1C20,0.448 19.553,0 19,0C18.447,0 18,0.448 18,1L18,3C18,3.552 18.447,4 19,4C19.553,4 20,3.552 20,3L20,1ZM6,3C6,3.552 5.553,4 5,4C4.447,4 4,3.552 4,3L4,1C4,0.448 4.447,0 5,0C5.553,0 6,0.448 6,1L6,3Z" style="fill-rule:nonzero;"/>
			</svg>
';
		}
		return $icon;
	}

	function add_projects_tab(){
		global $bp;
		$slug='calendar';
		//Add VibeDrive tab in profile menu
	    bp_core_new_nav_item( array( 
	        'name' => __('Calendar','vibecal'),
	        'slug' => $slug, 
	        'item_css_id' => 'all_articles',
	        'screen_function' => array($this,'show_screen'),
	        'default_subnav_slug' => 'home', 
	        'show_for_displayed_user'=>false,
	        'position' => 58,
	        'user_has_access' => (bp_is_my_profile() || current_user_can('manage_options'))
	    ) );

	    bp_core_new_subnav_item( array(
			'name' 		  => __('My Events','vibecal'),
			'slug' 		  => 'my_events',
			'parent_slug' => $slug,
        	'parent_url' => $bp->displayed_user->domain.$slug.'/',
			'screen_function' => array($this,'show_screen'),
			'user_has_access' => (bp_is_my_profile() || current_user_can('manage_options'))
		) );
		bp_core_new_subnav_item( array(
			'name' 		  => __('My Invites','vibecal'),
			'slug' 		  => 'my_invites',
			'parent_slug' => $slug,
        	'parent_url' => $bp->displayed_user->domain.$slug.'/',
			'screen_function' => array($this,'show_screen'),
			'user_has_access' => (bp_is_my_profile() || current_user_can('manage_options'))
		) );
		if (  class_exists( 'EventON' )  && apply_filters('show_eventon_vibecalendar',false)) {
			bp_core_new_subnav_item( array(
				'name' 		  => __('EventOn','vibecal'),
				'slug' 		  => 'eventon_events',
				'parent_slug' => $slug,
				'parent_url' => $bp->displayed_user->domain.$slug.'/',
				'screen_function' => array($this,'show_screen'),
				'user_has_access' => (bp_is_my_profile() || current_user_can('manage_options'))
			) );
		}

	}

	function show_screen(){

	}

	function enqueue_script(){

		$blog_id = '';
        if(function_exists('get_current_blog_id')){
            $blog_id = get_current_blog_id();
        }

            
		$kb=apply_filters('vibecal_script_args',array(
			'api'=>array(
                'url'=>get_rest_url($blog_id,VIBECAL_API_NAMESPACE),
            ),
            'title'=>__('Calendar','vibecal'),
			'settings'=>array(
            	'new_event_cap'=>['subscriber'],
            	'new_event_category_cap'=>['subscriber'],
            	'weekend'=>5,
				'timeslot'=>15,
				'views'=>array(
					'month'=>__('Month','vibecal'),
					'week'=>__('Week','vibecal'),
					'day'=>__('Day','vibecal')
				),
				'fields'=>array(
					array(
                        'label'=> __('Event Title','vibecal' ),
                        'type'=> 'title',
                        'id' => 'post_title',
                        'from'=>'post',
                        'value_type'=>'single',
                        'style'=>'full',
                        'default'=> __('Event Title','vibecal' ),
						),
					array(
						'label'=> __('Event Description','vibecal' ),
						'type'=> 'editor',
						'style'=>'',
						'value_type'=>'single',
						'id' => 'post_content',
						'from'=>'post',
						'extras' => '',
						'default'=> __('Enter a  description about the event.','vibecal' ),
					),
					array(
                        'label'=> __('Event Labels:','vibecal' ),
                        'type'=> 'label',
                        'style'=>'',
                        'value_type'=>'single',
                        'id' => 'event_labels',
                        'from'=>'meta',
                        'extras' => '',
                        'default'=> __('Event Labels.','vibecal' ),
					),
                    array(
                        'label'=> __('Event Color','vibecal' ),
                        'type'=> 'color',
                        'style'=>'',
                        'value_type'=>'single',
                        'id' => 'event_color',
                        'from'=>'meta',
                        'extras' => '',
                        'default'=> __('Event color.','vibecal' ),
					),
                    array(
                        'label'=> __('Start','vibecal' ),
                        'type'=> 'datetime',
                        'style'=>'',
                        'value_type'=>'single',
                        'id' => 'start',
                        'from'=>'meta',
                        'extras' => '',
                    ),
                    array(
                        'label'=> __('End','vibecal' ),
                        'type'=> 'datetime',
                        'style'=>'',
                        'value_type'=>'single',
                        'id' => 'end',
                        'from'=>'meta',
                        'extras' => '',
					)
				)
            ),
            'sorters'=>array(
                'recent'=>_x('Recent','login','vibecal'),
                'alphabetical'=>_x('Alphabetical','login','vibecal'),
            ),
            'translations'=>array(
            	'add_event'=>__('Add Event', 'vibecal'),
            	'edit_event'=>__('Edit Event', 'vibecal'),
				'add_new'=>__('Add New', 'vibecal'),
				'enter_title'=>__('Enter Title', 'vibecal'),
				'start'=>__('Start', 'vibecal'),
				'end'=>__('Ends', 'vibecal'),
				'enter_description'=>__('Enter Description', 'vibecal'),
				'create_event'=>__('Create Event', 'vibecal'),
				'save'=>__('Save', 'vibecal'),
				'cancel'=>__('Cancel', 'vibecal'),
				'more'=>__('More', 'vibecal'),
				'search_here'=>__('Search...', 'vibecal'),
				'search_users'=>__('Search Users', 'vibecal'),
				'load_more'=>__('Load more events', 'vibecal'),
				'participants'=>__('Participants', 'vibecal'),
				'starts'=>__('Starts', 'vibecal'),
				'ends'=>__('Ends', 'vibecal'),
				'pending_invites'=>__('Pending', 'vibecal'),
				'accepted_invites'=>__('Accepted', 'vibecal'),
				'rejected_invites'=>__('Rejected', 'vibecal'),
				'accept'=>__('Accept', 'vibecal'),
				'reject'=>__('Reject', 'vibecal'),
				'delete'=>__('Delete', 'vibecal'),
				'month'=>__('Month','vibecal'),
				'week'=>__('Week','vibecal'),
				'day'=>__('Day','vibecal'),
				'today' => __('Today','vibecal'),
				'list' => __('List','vibecal'),
				'unlimited' => __('Unlimited','vibecal'),
				'missing_data' => __('Missing data','vibecal'),
				'type_here' => __('Type here','vibecal'),
				'exit_from_event' =>  __('Exit from event','vibecal'),
				'inviter' =>  __('Inviter','vibecal'),
				'send_invite' =>  __('Send Invite','vibecal'),
				'no_invites' =>  __('No Invites Found','vibecal'),
				'start_url'=>  __('Start Url','vibecal'),
				'join_url'=>  __('Join Url','vibecal'),
				'timezone'=>  __('TimeZone','vibecal'),
				'invited_by'=> __('Invited By','vibecal'),
				'send_invites'=> __('Send Invites','vibecal'),
				'invited'=> __('Invited','vibecal'),
            )
        ));
        if(function_exists('bp_is_user') && bp_is_user() || apply_filters('vibebp_enqueue_profile_script',false)){
    		wp_deregister_script('jquery');

    		wp_enqueue_script('fullcalendar',plugins_url('assets/js/fullcalendar.min.js',__FILE__),array(),VIBECAL_VERSION,true);

    		// wp_enqueue_script('fullcalendar_daygrid',plugins_url('assets/js/daygrid.min.js',__FILE__),array(),VIBECAL_VERSION,true);
    		// wp_enqueue_script('fullcalendar_timegrid',plugins_url('assets/js/timegrid.min.js',__FILE__),array(),VIBECAL_VERSION,true);
    		// wp_enqueue_script('fullcalendar_interaction',plugins_url('assets/js/interaction.min.js',__FILE__),array(),VIBECAL_VERSION,true);
            wp_enqueue_script('vibecal',plugins_url('assets/js/cal.js',__FILE__),array('wp-element','wp-data','fullcalendar'),VIBECAL_VERSION,true);
            wp_localize_script('vibecal','vibecal',$kb);

            wp_enqueue_style('fullcalendar',plugins_url('assets/css/fullcalendar.min.css',__FILE__),array(),VIBECAL_VERSION);
            wp_enqueue_style('vibecal',plugins_url('assets/css/cal.css',__FILE__),array(),VIBECAL_VERSION);
        }
	}

	function register_custom_post_type(){
		register_post_type( VIBECAL_EVENT_POST_TYPE ,apply_filters('vibecal_event_register_post_type',
				array(
					'labels' => array(
						'name' => __('Events','vibecal'),
						'menu_name' => __('Vibe-Events','vibecal'),
						'singular_name' => __('Events','vibecal'),
						'add_new_item' => __('Add New Event','vibecal'),
						'all_items' => __('Events','vibecal')
					),
					'public' => true,
					'publicly_queryable' => true,
					'show_ui' => true,
					'capability_type' => 'post',
					'show_in_admin_bar' => true,
					'show_in_nav_menus' => true,
					'taxonomies' => array( 'events-cat'),
					'supports' => array( 'title','editor','thumbnail','author','comments','excerpt','revisions','custom-fields', 'page-attributes'),
					'hierarchical' => true,
					'rewrite' => array('slug' => 'events'),
					'show_in_menu' => defined('VIBEBP_VERSION')?'vibebp':'projects'
				)
			)
		);
	}

	function create_nonhierarchical_taxonomy() {
 
		register_taxonomy(VIBECAL_EVENT_TAXONOMY,VIBECAL_EVENT_POST_TYPE,array(
			'hierarchical' => true,
			'labels' => array(
					'name' => _x( 'Events Category', 'taxonomy general name' ),
					'singular_name' => _x( 'Category', 'taxonomy singular name' ),
					'search_items' =>  __( 'Search Events Category' ),
					'popular_items' => __( 'Popular Category' ),
					'all_items' => __( 'All Events Category' ),
				),
			'show_ui' => true,
			'show_admin_column' => true,
			'query_var' => true,
			'rewrite' => array( 'slug' => VIBECAL_EVENT_POST_TYPE ),
			'show_in_menu' => defined('VIBEBP_VERSION')?'vibebp':'projects'
		));

		register_taxonomy(VIBECAL_EVENT_CALENDAR,VIBECAL_EVENT_POST_TYPE,array(
			'hierarchical' => true,
			'labels' => array(
					'name' => _x( 'Events Calendar', 'taxonomy general name' ),
					'singular_name' => _x( 'Calendar', 'taxonomy singular name' ),
					'search_items' =>  __( 'Search Calendar' ),
					'all_items' => __( 'All Calendars' ),
				),
			'show_ui' => true,
			'show_admin_column' => true,
			'query_var' => true,
			'rewrite' => array( 'slug' => VIBECAL_EVENT_POST_TYPE ),
			'show_in_menu' => defined('VIBEBP_VERSION')?'vibebp':'projects'
		));

		
	}
}
Vibe_Cal_Init::init();



 

 
