<?php
/*
Plugin Name: VibeDrive
Plugin URI: https://vibethemes.com/vibedrive
Description: Create a Drive for BuddyPress, Members, Groups and others
Version: 1.0
Requires at least: WP 3.8, BuddyPress 1.9 
Tested up to: 5.1
License:     GPLv2 or later (LICENSE.txt)
Author: VibeThemes
Author URI: http://www.VibeThemes.com
Text Domain: vibedrive
Domain Path: /languages/

*/
if ( !defined( 'ABSPATH' ) ) exit; 

if(!defined('VIBEDRIVE_VERSION')){
    define('VIBEDRIVE_VERSION',rand(0,999));
}

if(!defined('VIBEDRIVE_SETTINGS_OPTION')){
    define('VIBEDRIVE_SETTINGS_OPTION','vibedrive');
}

include_once 'includes/class.actions.php';
include_once 'includes/class.admin.php';
include_once 'includes/class.api.php';
include_once 'includes/class.filters.php';
include_once 'includes/functions.php';
include_once 'includes/class.init.php';
include_once 'includes/class.updater.php';




add_action('plugins_loaded','vibedrive_translations');
function vibedrive_translations(){
    $locale = apply_filters("plugin_locale", get_locale(), 'vibedrive');
    $lang_dir = dirname( __FILE__ ) . '/languages/';
    $mofile        = sprintf( '%1$s-%2$s.mo', 'vibedrive', $locale );
    $mofile_local  = $lang_dir . $mofile;
    $mofile_global = WP_LANG_DIR . '/plugins/' . $mofile;

    if ( file_exists( $mofile_global ) ) {
        load_textdomain( 'vibedrive', $mofile_global );
    } else {
        load_textdomain( 'vibedrive', $mofile_local );
    }  
}
